import express from 'express';
import fetch from 'node-fetch';
import dotenv from 'dotenv';

dotenv.config();
const app = express();

app.get('/auth/callback', async (req, res) => {
    const code = req.query.code;
    if (!code) return res.send('Código não fornecido');

    const params = new URLSearchParams();
    params.append('client_id', process.env.CLIENT_ID);
    params.append('client_secret', process.env.CLIENT_SECRET);
    params.append('grant_type', 'authorization_code');
    params.append('code', code);
    params.append('redirect_uri', process.env.REDIRECT_URI);

    const response = await fetch('https://discord.com/api/oauth2/token', {
        method: 'POST',
        body: params,
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        }
    });

    const data = await response.json();

    if (data.access_token) {
        // Aqui você pode salvar na sessão ou continuar o login
        res.send('Login realizado com sucesso!');
    } else {
        console.error(data);
        res.send('Erro ao autenticar com Discord');
    }
});

app.listen(3000, () => {
    console.log('Servidor rodando em http://localhost:3000');

app.get('/auth/callback', async (req, res) => {
        const code = req.query.code;
        if (!code) return res.send('Código ausente');
      
        const params = new URLSearchParams({
          client_id: process.env.CLIENT_ID,
          client_secret: process.env.CLIENT_SECRET,
          grant_type: 'authorization_code',
          code,
          redirect_uri: process.env.REDIRECT_URI,
          scope: 'identify guilds guilds.members.read'
        });
      
        try {
          const response = await axios.post('https://discord.com/api/oauth2/token', params, {
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
          });
      
          const token = response.data.access_token;
          res.redirect('/index.html'); // se seu dashboard estiver em "public/dashboard.html"
        } catch (err) {
          res.status(500).send('Erro ao autenticar com o Discord.');
        }
      });
      
});
